Google OAuth Security Checklist
===============================

This document summarizes how MiBa Video Manager completes the Google OAuth 2.0 desktop flow in a way that satisfies Google’s [secure flow requirements](https://support.google.com/cloud/answer/15548748#use-secure-flows&zippy=%2Capp-security).

Key Controls
------------

1. Proof Key for Code Exchange (PKCE)
   - Each authentication attempt now generates a per-session `code_verifier` and derived `code_challenge` (`S256` method).
   - The verifier is supplied when exchanging the authorization code so the issued tokens are bound to the originating client instance.

2. CSRF Protection via `state`
   - A high-entropy, URL-safe `state` token is attached to the authorization request.
   - The local callback handler verifies that the returned `state` matches the session token before exchanging codes.

3. Ephemeral Session Secrets
   - PKCE verifiers and `state` tokens are kept entirely in memory; they are never written to disk.
   - Secrets are cleared on successful token exchange, cancellation, timeout, or any callback error.

4. Local Redirect Binding
   - The embedded HTTP callback server only accepts requests on `127.0.0.1:4587` and shuts down immediately after handling a response, reducing the window for spoofed callbacks.

Operational Notes
-----------------

- The renderer process should always call `session.waitForTokens()` (or `session.cancel()`) after launching the external browser so that secrets are cleaned up promptly.
- If you encounter Google warnings about “insecure OAuth flows,” confirm that you are running a build containing these hardening updates and that your OAuth client configuration lists `http://127.0.0.1:4587/oauth2/callback` as an authorized redirect URI.


